/*
 * Decompiled with CFR 0.152.
 */
package core.states;

import core.GameWindow;
import core.MinionInvaders;
import core.enums.Difficulty;
import core.enums.Mode;
import core.enums.State;
import core.states.GameState;
import core.states.StateIf;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.WheelWidget;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.ButtonModel;
import de.matthiasmann.twl.model.SimpleButtonModel;
import de.matthiasmann.twl.model.SimpleChangableListModel;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.theme.ThemeManager;
import java.io.IOException;
import java.net.URL;
import org.lwjgl.LWJGLException;
import util.ResourceManager;

public final class MainMenuState
extends Widget
implements StateIf {
    private static final MainMenuState single = new MainMenuState();
    private GUI gui;
    private MinionInvaders game;
    private SimpleChangableListModel<String> modeList;
    private SimpleChangableListModel<String> difficultyList;
    private SimpleChangableListModel<String> levelList;
    private WheelWidget<String> modeWheel;
    private WheelWidget<String> difficultyWheel;
    private WheelWidget<String> levelWheel;
    private SimpleButtonModel buttonModelOK;
    private Button buttonOK;
    private boolean buttonOKIsPressed = false;
    private int modeX;
    private int difficultyX;
    private int levelX;
    private int modeWheelSelection = 0;
    private int difficultyWheelSelection = 1;
    private int levelWheelSelection = 0;

    public static MainMenuState get() {
        return single;
    }

    private MainMenuState() {
        this.setTheme("minioninvaders");
        this.modeList = new SimpleChangableListModel((Object[])new String[]{"Story", "Survival"});
        this.modeWheel = new WheelWidget(this.modeList);
        this.modeWheel.setCyclic(false);
        this.add((Widget)this.modeWheel);
        this.difficultyList = new SimpleChangableListModel((Object[])new String[]{"Easy", "Medium", "Hard", "Legendary"});
        this.difficultyWheel = new WheelWidget(this.difficultyList);
        this.difficultyWheel.setCyclic(false);
        this.add((Widget)this.difficultyWheel);
        this.buildLevelWheel();
        this.add((Widget)this.levelWheel);
        this.buttonModelOK = new SimpleButtonModel();
        this.buttonOK = new Button();
        this.buttonOK.setTheme("normalButton");
        this.buttonOK.setText("Start");
        this.buttonOK.setModel((ButtonModel)this.buttonModelOK);
        this.add((Widget)this.buttonOK);
        this.game = ResourceManager.get().getGame();
        try {
            LWJGLRenderer renderer = new LWJGLRenderer();
            this.gui = new GUI((Widget)this, (Renderer)renderer);
            ThemeManager theme = ThemeManager.createThemeManager((URL)ResourceManager.get().getResource("/resources/ui.xml"), (Renderer)renderer);
            this.gui.applyTheme(theme);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reinit();
    }

    private void buildLevelWheel() {
        int unlockedLevels = this.game == null ? 1 : GameState.get().getLevelFromProps();
        this.levelList = new SimpleChangableListModel();
        int i = 1;
        while (i <= unlockedLevels) {
            this.levelList.addElement((Object)("Level " + i));
            ++i;
        }
        this.levelWheel = new WheelWidget(this.levelList);
        this.levelWheel.setCyclic(false);
    }

    public void reinit() {
        this.removeChild((Widget)this.levelWheel);
        this.buildLevelWheel();
        this.add((Widget)this.levelWheel);
        this.modeWheel.setSelected(this.modeWheelSelection);
        this.difficultyWheel.setSelected(this.difficultyWheelSelection);
        this.levelWheel.setSelected(this.levelWheelSelection);
    }

    protected void layout() {
        this.modeWheel.adjustSize();
        this.difficultyWheel.adjustSize();
        this.levelWheel.adjustSize();
        this.modeX = (int)ResourceManager.get().getDimension().getWidth() / 2 - (this.modeWheel.getWidth() + this.difficultyWheel.getWidth() + this.levelWheel.getWidth()) / 2;
        this.modeWheel.setPosition(this.modeX, 220);
        this.difficultyX = this.modeX + this.modeWheel.getWidth() + 5;
        this.difficultyWheel.setPosition(this.difficultyX, 220);
        this.levelX = this.difficultyX + this.difficultyWheel.getWidth() + 5;
        this.levelWheel.setPosition(this.levelX, 220);
        this.buttonOK.adjustSize();
        this.buttonOK.setSize(this.buttonOK.getWidth() + 10, this.buttonOK.getHeight());
        this.buttonOK.setPosition((int)ResourceManager.get().getDimension().getWidth() / 2 - this.buttonOK.getWidth() / 2, 450);
    }

    public void update() {
        this.render();
    }

    @Override
    public void render(long delta) {
        this.render();
    }

    public void render() {
        GameWindow window = ResourceManager.get().getGameWindow();
        int width = (int)ResourceManager.get().getDimension().getWidth();
        window.drawText(GameWindow.FONT_TITLE, width / 2, 20.0f, "M i n i o n  I n v a d e r s", 2);
        window.drawText(GameWindow.FONT_MENU, width / 2, 120.0f, "Select game settings!", 2);
        window.drawText(GameWindow.FONT_SMALL, this.modeX, 400.0f, "Drag the setting wheels with the mouse");
        window.drawText(GameWindow.FONT_SMALL, width - 10, 535.0f, "A game by Daniel Figge", 3);
        window.drawText(GameWindow.FONT_MENU, this.modeX, 190.0f, "Mode");
        window.drawText(GameWindow.FONT_MENU, this.difficultyX, 190.0f, "Difficulty");
        window.drawText(GameWindow.FONT_MENU, this.levelX, 190.0f, "Level");
        this.gui.update();
        if (this.buttonModelOK.isPressed()) {
            if (!this.buttonOKIsPressed) {
                this.buttonOKIsPressed = true;
                this.modeWheelSelection = this.modeWheel.getSelected();
                this.difficultyWheelSelection = this.difficultyWheel.getSelected();
                this.levelWheelSelection = this.levelWheel.getSelected();
                Mode mode = null;
                if (((String)this.modeList.getEntry(this.modeWheelSelection)).equalsIgnoreCase("story")) {
                    mode = Mode.STORY;
                } else if (((String)this.modeList.getEntry(this.modeWheelSelection)).equalsIgnoreCase("survival")) {
                    mode = Mode.SURVIVAL;
                } else if (((String)this.modeList.getEntry(this.modeWheelSelection)).equalsIgnoreCase("touhou")) {
                    mode = Mode.TOUHOU;
                }
                GameState.get().setMode(mode);
                Difficulty difficulty = null;
                if (((String)this.difficultyList.getEntry(this.difficultyWheelSelection)).equalsIgnoreCase("easy")) {
                    difficulty = Difficulty.EASY;
                } else if (((String)this.difficultyList.getEntry(this.difficultyWheelSelection)).equalsIgnoreCase("medium")) {
                    difficulty = Difficulty.MEDIUM;
                } else if (((String)this.difficultyList.getEntry(this.difficultyWheelSelection)).equalsIgnoreCase("hard")) {
                    difficulty = Difficulty.HARD;
                } else if (((String)this.difficultyList.getEntry(this.difficultyWheelSelection)).equalsIgnoreCase("legendary")) {
                    difficulty = Difficulty.LEGENDARY;
                }
                GameState.get().setDifficulty(difficulty);
                this.game.setState(State.GAME);
                GameState.get().setLevel(Integer.parseInt(((String)this.levelList.getEntry(this.levelWheelSelection)).replace("Level ", "")));
            }
        } else {
            this.buttonOKIsPressed = false;
        }
    }
}

